using System;

class Program
{
    const float preciznost = 0.000001f;

    struct Trkac
    {
        public float Brzina { get; private set; }
        public float Pozicija { get; private set; }

        public Trkac(float pozicija, float brzina)
        {
            this.Brzina = brzina;
            this.Pozicija = pozicija;
        }
    }

    static uint BrojPreticanjaNaPoziciji(Trkac[] trkaci, float pozicija, uint dimenzija)
    {
        var preticanja = 0u;
        var vreme = (pozicija - trkaci[0].Pozicija) / trkaci[0].Brzina;

        for(int i = 0; i < dimenzija; i++)
        {
            var pozicijaTrenutnog = trkaci[i].Pozicija + vreme * trkaci[i].Brzina; 
            for(int j = i + 1; j < dimenzija; j++)
            {
                var pozicijaNovog = trkaci[j].Pozicija + vreme * trkaci[j].Brzina;
                if ((pozicijaTrenutnog - pozicijaNovog) >= 0)
                {
                    preticanja++;
                }
            }
        }

        return preticanja;
    }


    static void Main()
    {
        var dimenzija = Console.ReadLine().Split(' ');
        var brojTrkaca = uint.Parse(dimenzija[0]);
        var brojPreticanja = uint.Parse(dimenzija[1]);

        var trkaci = new Trkac[brojTrkaca];
        for(int i = 0; i < brojTrkaca; i++)
        {
            var podaci = Console.ReadLine().Split(' ');
            trkaci[i] = new Trkac(float.Parse(podaci[0]), float.Parse(podaci[1]));
        }

        var levi = 0f;
        var desni = float.MaxValue;
        var resenje = float.MaxValue;

        while((levi - desni) <= preciznost)
        {
            var srednji = (desni + levi) / 2;
            var preticanja = BrojPreticanjaNaPoziciji(trkaci, srednji, brojTrkaca);
            if(preticanja < brojPreticanja)
            {
                levi = srednji + preciznost;
            }
            else
            {
                desni = srednji - preciznost;
            }
            resenje = (srednji - trkaci[0].Pozicija) / trkaci[0].Brzina;
        }

        Console.WriteLine(resenje.ToString(".000000000"));
    }
}